DROP INDEX BENS.ACTST_PK;

CREATE UNIQUE INDEX BENS.ACTST_PK ON BENS.ACTIVATION_STATE
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTCRT_ORG_FK_I;

CREATE INDEX BENS.CNTCRT_ORG_FK_I ON BENS.CONTACT_CERTIFICATE
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTCRT_PK;

CREATE UNIQUE INDEX BENS.CNTCRT_PK ON BENS.CONTACT_CERTIFICATE
(CONTACT_CERTIFICATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTDTL_ORG_FK_I;

CREATE INDEX BENS.CNTDTL_ORG_FK_I ON BENS.CONTACT_DETAIL
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTDTL_PK;

CREATE UNIQUE INDEX BENS.CNTDTL_PK ON BENS.CONTACT_DETAIL
(CONTACT_DETAIL_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTPHN_CNTDRL_FK_I;

CREATE INDEX BENS.CNTPHN_CNTDRL_FK_I ON BENS.CONTACT_PHONE
(CONTACT_DETAIL_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.CNTPHN_PK;

CREATE UNIQUE INDEX BENS.CNTPHN_PK ON BENS.CONTACT_PHONE
(CONTACT_PHONE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSCOM_EVNCLS_FK_I;

CREATE INDEX BENS.EVNCLSCOM_EVNCLS_FK_I ON BENS.EVENT_CLASS_COMMENT
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSCOM_PK;

CREATE UNIQUE INDEX BENS.EVNCLSCOM_PK ON BENS.EVENT_CLASS_COMMENT
(EVENT_CLASS_COMMENT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSRGS_EVNCLS_FK_I;

CREATE INDEX BENS.EVNCLSRGS_EVNCLS_FK_I ON BENS.EVENT_CLASS_REGISTRANT
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSRGS_PK;

CREATE UNIQUE INDEX BENS.EVNCLSRGS_PK ON BENS.EVENT_CLASS_REGISTRANT
(EVENT_CLASS_REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSRGS_REG_FK_I;

CREATE INDEX BENS.EVNCLSRGS_REG_FK_I ON BENS.EVENT_CLASS_REGISTRANT
(REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLSRGS_RELTYPNAM_NU_I;

CREATE INDEX BENS.EVNCLSRGS_RELTYPNAM_NU_I ON BENS.EVENT_CLASS_REGISTRANT
(RELATIONSHIP_TYPE_NAME)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLS_ACTST_FK_I;

CREATE INDEX BENS.EVNCLS_ACTST_FK_I ON BENS.EVENT_CLASS
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLS_EVNCOD_FK_I;

CREATE INDEX BENS.EVNCLS_EVNCOD_FK_I ON BENS.EVENT_CLASS
(EVENT_CODE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLS_PEVNCLS_FK_I;

CREATE INDEX BENS.EVNCLS_PEVNCLS_FK_I ON BENS.EVENT_CLASS
(PARENT_EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLS_PK;

CREATE UNIQUE INDEX BENS.EVNCLS_PK ON BENS.EVENT_CLASS
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCLS_SPN_FK_I;

CREATE INDEX BENS.EVNCLS_SPN_FK_I ON BENS.EVENT_CLASS
(SPONSOR_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCOD_PK;

CREATE UNIQUE INDEX BENS.EVNCOD_PK ON BENS.EVENT_CODE
(EVENT_CODE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCTLENT_EVTCLS_FK_I;

CREATE INDEX BENS.EVNCTLENT_EVTCLS_FK_I ON BENS.EVENT_CATALOG_ENTRY
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCTLENT_PK;

CREATE UNIQUE INDEX BENS.EVNCTLENT_PK ON BENS.EVENT_CATALOG_ENTRY
(EVENT_CATALOG_ENTRY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.EVNCTLENT_TXNVER_FK_I;

CREATE INDEX BENS.EVNCTLENT_TXNVER_FK_I ON BENS.EVENT_CATALOG_ENTRY
(TAXONOMY_VERSION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.ORGCOM_ORG_FK_I;

CREATE INDEX BENS.ORGCOM_ORG_FK_I ON BENS.ORGANIZATION_COMMENT
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.ORGCOM_PK;

CREATE UNIQUE INDEX BENS.ORGCOM_PK ON BENS.ORGANIZATION_COMMENT
(ORGANIZATION_COMMENT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.ORG_PK;

CREATE UNIQUE INDEX BENS.ORG_PK ON BENS.ORGANIZATION
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.REG_ACRST_FK_I;

CREATE INDEX BENS.REG_ACRST_FK_I ON BENS.REGISTRANT
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.REG_ORG_FK_I;

CREATE INDEX BENS.REG_ORG_FK_I ON BENS.REGISTRANT
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.REG_PK;

CREATE UNIQUE INDEX BENS.REG_PK ON BENS.REGISTRANT
(REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.TAXVER_PK;

CREATE UNIQUE INDEX BENS.TAXVER_PK ON BENS.TAXONOMY_VERSION
(TAXONOMY_VERSION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.TAXVER_TAX_FK_I;

CREATE INDEX BENS.TAXVER_TAX_FK_I ON BENS.TAXONOMY_VERSION
(TAXONOMY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.TAX_PK;

CREATE UNIQUE INDEX BENS.TAX_PK ON BENS.TAXONOMY
(TAXONOMY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX BENS.TAX_SPN_FK_I;

CREATE INDEX BENS.TAX_SPN_FK_I ON BENS.TAXONOMY
(SPONSOR_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
